

<?php $__env->startSection('title', 'Módulo de Estilos'); ?>

<?php $__env->startSection('content'); ?>

    <div class="content-wrapper">
    
        <div class="page-header row">

            <h3 class="page-title">
                ADMINISTRACIÓN DE ESTILOS
            </h3>

            <div class="template-demo mt-20">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb breadcrumb-custom"">
                        <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>" class="colorfont"> <i class="fas fa-fw fa-home"></i> Inicio</a></li>
                        <li class="breadcrumb-item active" aria-current="page"> <i class="fas fa-paint-roller"></i> Estilos</li>
                    </ol>
                </nav>
            </div>

        </div>
        
        <div class="row">

            <div class="col-12 grid-margin stretch-card">

                <div class="card">

                    <form method="POST" action="<?php echo e(url('admin/estilos')); ?>" enctype="multipart/form-data" id="formEstilos">

                        <?php echo csrf_field(); ?>

                        <div class="card-body">

                            <div class="form-group row">

                                <?php $__currentLoopData = $estilos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $e): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                <h3 class="card-title col-12"><?php echo e($k); ?></h3>

                                    <?php $__currentLoopData = $e; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                        <div class="col-md-4 col-sm-12 mb-3">

                                            <div style="background:#eee;border:1px solid #ddd;padding:15px 36px;overflow:hidden;">
                                                <label><b><?php echo e($i->nombre); ?>:</b></label>
                                                <input type='text' class="color-picker" name="valor[<?php echo e($i->estilo_id); ?>][]" style="width:90%;" value="<?php echo e($i->valor!="" ? $i->valor : ''); ?>" />
                                            </div>

                                        </div>

                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </div>

                        </div>

                        <div class="card-footer">

                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('admin.estilos.actualizar')): ?>
                                <center><button type="submit" class="btn btn-dark btn-icon-split" id="guardarEstilos"><span class="icon text-white-50"><img src="<?php echo e(url('admin_assets/images/save.png')); ?>" width="32px"></span><span class="text">Guardar</span></button></center>
                            <?php endif; ?>

                        </div>

                    </form>

                </div>
            
            </div>


        </div>

    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>

    <script src="<?php echo e(asset('admin_assets/js/formpickers.js')); ?>"></script>

    <script>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('admin.estilos.actualizar')): ?>
            $('#guardarEstilos').click(function(event){
                event.preventDefault();
                guardarEstilos();
            });

            window.guardarEstilos = function(){

                $("#guardarEstilos").prop('disabled', true);
                let url = $('meta[name=app-url]').attr("content") + "/admin/estilos";
                let formData = new FormData($("#formEstilos")[0]); 
                formData.append('usuario',<?php echo '"'.Auth::user()->usuario.'"'; ?>)
                $.ajax({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    url: url,
                    type: "POST",
                    data: formData,
                    processData: false,  // tell jQuery not to process the data
                    contentType: false,  // tell jQuery not to set contentType
                    success: function(response) {
                        $("#guardarEstilos").prop('disabled', false);
                        if(response.code == "200")
                        {   
                            Swal.fire({
                            icon: 'success',
                            title: 'ÉXITO!',
                            text: 'Se han guardado los estilos correctamente',
                            showCancelButton: false,
                            allowOutsideClick: false,
                            confirmButtonColor: '#3085d6',
                            confirmButtonText: 'OK'
                            }).then((result) => {
                                if (result.isConfirmed) {
                                    window.location = response.url;
                                }
                            });
                        }
                        else 
                        {
                            Swal.fire({
                            icon: 'error',
                            title: 'ERROR...',
                            text: 'Se ha producido un error al intentar guardar el registro!'
                        })
                        }
                    },
                    error: function(response) {
                        $("#guardarEstilos").prop('disabled', false);

                        Swal.fire({
                            icon: 'error',
                            title: 'ERROR...',
                            text: 'Se ha producido un error al intentar guardar el registro!'
                        })
                    }
                });
            }
        <?php endif; ?>

    </script>


<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/logincmc/labodega.logincm.com/resources/views/admin/modules/estilos.blade.php ENDPATH**/ ?>